<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\User;

use Erlage\Photogram\Data\Models\AbstractFinder;
use Erlage\Photogram\Data\Tables\User\UserTable;

final class UserFinder extends AbstractFinder implements InterfaceUserSetter
{
    /**
     * setter interface
     */
    use TraitUserSetters;

    public function getTableName(): string
    {
        return UserTable::getTableName();
    }

    /**
     * @return mixed 
     */
    public function getAtrributeValue(string $attribute)
    {
        return $this -> {UserTable::CAMEL_CASE_MAP[$attribute]}
        ?? null;
    }

    public function popModelFromResults(): UserModel
    {
        return UserModel::createFromUntouchedBean_noException(parent::pop());
    }
}
